
DumbInput=function(parent){
	this.lastKeyTime=new Date();
	this.buf="";
	this.log=new Logger("DumbInput");
	this.parent=parent;
//	this.log.leave("Created");
//	this.lastKey="";
}

DumbInput.prototype.newCharDelay=3000;
DumbInput.prototype.kbLayout = new Array(" ",".()\",+=_","ABC","DEF","GHI","JKL","MNO","PQRS","TUV","WXYZ");

DumbInput.prototype.doDigit=function(key){
	var now = new Date();
	var log=this.log.enter("doDigit");
//	var last = this.lastKeyTime;
	var i=-2;
	var digit=key;//.charCodeAt(0)-0x30;
	var L=this.kbLayout[digit];
	log.log("Buf:" + this.buf+";" + this.buf.length + ";"+digit +";" + L + ";");
	try {
		if (this.buf.length>0) {
			if (howLong(this.lastKeyTime,now)>this.newCharDelay) {
				log.log("Timeout");
				return null;	//timeout - go to next letter and empty buffer before that
			};
			i=L.indexOf(this.buf.charAt(0).toUpperCase());
			if (i<0) {
				log.log("Key change");
				return null;			//different key was pressed - as above
			}
			i++;
			if (i==L.length) i=0;
			this.buf=this.setCase(L.charAt(i));
//		this.log.log("buf set to "+this.buf+ ", " i);
		} else this.buf=this.setCase(L.charAt(0));
		log.log("buf set to:"+this.buf+ ", " + i);
		this.lastKeyTime=new Date();
		log.leave();
		return this.buf;
	} catch(e) {
		log.error(e);
	}
}

DumbInput.prototype.getCase=function() {
	this.log.log("getCase Enter");
	try {
		switch (this.parent.textCase) {
			case this.parent.CLOWER:
				return 0;
				break;
			case this.parent.CUPPER:
				return 1;
				break;
			case this.parent.CDYNAMIC:
				return this.parent.forceUpperCase;
				break;
		}	
	} catch(e) {
		this.log.error(e,"getCase");
	}
	this.log.log("getCase Leave");
}

DumbInput.prototype.setCase=function(data) {
	var log=this.log.enter("setCase");
	try {
		if (!this.buf.length) {
			this.caseBuf=this.getCase();
		}
		log.leave(this.caseBuf);
		if (this.caseBuf) return data.toUpperCase(); else return data.toLowerCase();
	} catch(e) {log.error(e);}
}

DumbInput.prototype.getBuf=function(noflush) {
	this.log.log("getBuf");
	var s = this.buf;
	if (!noflush) this.buf="";
	return s;
}

DumbInput.prototype.showCursor=function() {
	try {
		this.log.log("showCursor");
		if (this.buf.length) {
			return this.buf+"_";
		} else {
			return "_";
		}
	} catch(e) { this.log.error(e,"showCursor");}
	this.log.log("showCursor Leave");
}

TextInput=function(owner,dfunc,_op) {
	this.log=new Logger("TextInput");
	try {
		var f;
		var debug=0;
//		this.log.log("Create");
		this.log.log(owner);
		this.log.log(dfunc);
		this.log.log(_op);
		if (_op) 
			this.opts=this.defaults.merge(_op);
		else
			this.opts=this.defaults;
		this.log.log("A");
		this.log.log(this.defaults.toString());
		this.log.log("A");
		this.log.log(this.opts.toString());
		this.log.log("A");
		this.buf="";
		this.modules={};
		this.modules[this.MDUMB]=new DumbInput(this);
		this.log.log(DictNode)
		this.log.log(DictRoot)
		this.log.log(DictWalker)
//FIXME:wybor slownika z opcji	
		this.modules[this.MT9]=new DictWalker(this.opts.dict,this);
//FIXME:zrobic to samo, co z casem
		if (!this.opts.mode) this.opts.mode=this.MDUMB;
		this.module=this.modules[this.opts.mode];
		this.UI = owner;
		this.owner=owner;
		this.dfunc=dfunc;
		this.pos=0;
		this.log.log(owner[dfunc])
		if (this.opts.textCase) 
			this.textCase=this.opts.textCase;
		else {
//tu trzeba wybrac pierwszy dostepny case
			this.textCase=this.CDYNAMIC;
		}

		//FIXME: this is temporary...
		if (MyDocument.AUTORUN_GROUP.lang) {
			MyDocument.AUTORUN_GROUP.lang.setValue(this.opts.dict);;
			MyDocument.AUTORUN_GROUP.textcase.setValue(this.CDESC[this.textCase]);
			MyDocument.AUTORUN_GROUP.textmode.setValue(this.MDESC[this.opts.mode]);
		}
		this.UI.setVariable("TEXT_CASE",this.opts.dict+"   " + this.CDESC[this.textCase]);
		this.UI.setVariable("TEXT_MODE",this.MDESC[this.opts.mode]);
		
		this.forceUpperCase=0;
		this.lastRefresh=new Date();
		this.lastKeyPressTime=new Date();
	} catch(e) {this.log.error(e);}
/*
//fails!!!!!!!!!!!
	try{
		f=this.owner[dfunc];
		f("init ok");
	}catch(e){
		this.log.log("failed 1 " +e.toString());
	}
*/

/*
	try{
		this.owner[this.dfunc]("init ok");
	}catch(e){
		this.log.log("failed 4 " +e.toString());
	}
*/
}

TextInput.prototype.timerDelay=500;
TextInput.prototype.refreshTimeout=3000;
TextInput.prototype.maxCharsDelay=5;

TextInput.prototype.CUPPER=1;
TextInput.prototype.CLOWER=1<<1;
TextInput.prototype.CDYNAMIC=1<<2;

//must be equal to the biggest of C*
TextInput.prototype.CMAX=TextInput.prototype.CDYNAMIC;
//sum of C*
TextInput.prototype.CALL=0x07;

TextInput.prototype.CDESC=[];
TextInput.prototype.CDESC[TextInput.prototype.CUPPER]="ABC";
TextInput.prototype.CDESC[TextInput.prototype.CLOWER]="abc";
TextInput.prototype.CDESC[TextInput.prototype.CDYNAMIC]="Abc";

TextInput.prototype.MDUMB=1;
TextInput.prototype.MT9=1<<1;
TextInput.prototype.MALL=0x03;

TextInput.prototype.MDESC=[];
TextInput.prototype.MDESC[TextInput.prototype.MDUMB]="XX";
TextInput.prototype.MDESC[TextInput.prototype.MT9]="T9";

//FIXME: load'em
TextInput.prototype.defaults = new Options("UIEdit.defaults");

TextInput.prototype.isFocused=function(){
	var log=this.log.enter("isFocused");
	log.log(this.owner.isFocused);
	try {
		if (this.owner.isFocused)  {
			log.log(this.owner.isFocused());
			return this.owner.isFocused();
		} else return false;
	} catch (e) {log.error(e)}
}

//FIXME: ale wyglada na to, ze na raize jest dobrze
TextInput.prototype.doMark = function(){
	var log = this.log.enter("doMark");
	
	try {
		if (this.opts.mode==this.MDUMB) {
			this.doMarkMenu();
			log.leave('no dict mode');
			return;
		}
		log.log("select");
		if (this.module.doMark) this.module.doMark();
		log.leave();
	} catch(e){log.error(e)}
}
//FIXME: napisac zmeinianie slownikow
TextInput.prototype.doMarkMenu = function(){
	var log = this.log.enter("doMarkMenu");
	
	try {
		if (this.module.doMarkMenu) this.module.doMarkMenu();
		log.leave();
	} catch(e){log.error(e)}
//wyswietl, 
//sprawdz czy sie zmienil
//zmien modul
//display
}

TextInput.prototype.doDigit=function(part) {
	var log=this.log.enter("doDigit");
	var key=part.key.charCodeAt(0)-0x30;
	var c,s;
	this.keyPressNote();
	
	try{
//		log.log(this.module);
//		log.log(this.module.doDigit);
		c=this.module.doDigit(key);
		log.log(c);
		if (c==null) {
			log.log(c);
			c=this.module.getBuf();
			log.log(c);
			this.buf=this.buf.insert(c,this.pos);
			log.log(this.buf);
			this.pos+=c.length;
			c=this.module.doDigit(key);
		} else {
			log.log(c.blink);
			log.log(typeof(c));
			if (c.blink) {
				log.log("blink");
				this.UI.bubble("doBlink");
			}
		}
		log.log("finally",c);
//		s=this.buf.insert(c,this.pos);
//		s=s.insert("_",this.pos+c.length);
//		this.log.log("display");
//		this.owner[this.dfunc](s);//+"   -"+(this.pos+c.length));
		this.showCursor(c);
	} catch (e) {this.log.error(e,"doDigit");}
	log.leave();
}


TextInput.prototype.display=function(param,_sync){
	try{
		this.log.log("display");
		this.log.log(param);
		if (this.sync || _sync) {	//synchronous display is forced
			this.log.log("sync display");
			this.display2(param);
			return 0;
		}
		this.log.log(typeof(param));
		this.log.log(this.owner._active);
		var teraz=new Date();
		if (howLong(this.lastRefresh,teraz)>this.refreshTimeout) {
			//refreshTimeout has passed
			this.log.log("REFRESH TIMEOUT");
			this.display2(param);
			return 0;
		};
		if (typeof(param)=="object") {
			//we're here from the timers' callback
			if (howLong(param.lastKeyPressTime,this.lastKeyPressTime)==0) {    //no key has been pressed since timer start
				this.display2(param);
				this.log.log("KEYPRESS TIMEOUT");
			} 
				else this.log.log("CHANGED KEYPRESS TIMEOUT");

			return 0;
		}
		//we're here from some key press func - param contains a string to display;
		this.log.log("START THE TIMER");
		//start the timer;
		var timer=new Timer();
		timer.obj=this;
		this.log.log("TM");
		timer.func="display";
		this.log.log("TM");
		timer.onCallback=function(){
			this.obj[this.func](this);
		};
		this.log.log("TM");
		timer.value=param;
		this.log.log("TM");
		timer.lastKeyPressTime=this.lastKeyPressTime;
		this.log.log("TM");
		timer.schedule(this.timerDelay);
		this.log.log("display Leave");
	} catch(e) { this.log.error(e,"display");}
}

TextInput.prototype.keyPressNote=function(){
	this.lastKeyPressTime=new Date();
	this.log.log("KEYPRESS NOTE");
}

TextInput.prototype.display2=function(param) {
	var s;
	if (typeof(param)=="object") s=param.value; else s=param;
	this.owner[this.dfunc](s);
	//FIXME: this is temporary...		
	if (MyDocument.AUTORUN_GROUP.lang) {
		MyDocument.AUTORUN_GROUP.lang.setValue(this.opts.dict);;
		MyDocument.AUTORUN_GROUP.textcase.setValue(this.CDESC[this.textCase]);
		MyDocument.AUTORUN_GROUP.textmode.setValue(this.MDESC[this.opts.mode]);
	}
	this.UI.setVariable("TEXT_CASE",this.opts.dict+"   " + this.CDESC[this.textCase]);
	this.UI.setVariable("TEXT_MODE",this.MDESC[this.opts.mode]);
	this.lastRefresh=new Date();
	this.keysPressedSinceRefresh=0;
}

TextInput.prototype.nextWord=function(dir){
	var log=this.log.enter("nextWord",dir);
	var s;
	try{
		if (this.module.nextWord) {
//FIXME: there should be a better way to do it...
			this.buf="";
			s=this.module.nextWord(dir);
			this.showCursor();
			log.leave(s);
			return s;
		}
	} catch(e) { this.log.error(e);}
}


TextInput.prototype.doMove=function(dir){
	this.keyPressNote();
	var log=this.log.enter("doMove",dir);
	var buflen,served=false,delta=0;

//	c=this.module.getBuf();
//	this.log.log("doMove " + c +";");
//	if (c.length>0) {
//		this.buf=this.buf.insert(c,this.pos);
//		this.pos+=c.length;
//	}

	if (this.module.doMove) {
			served=this.module.doMove(dir);	//powinno zwrocic nie-zero jesli obsluzyl poruszenie
	};
	if (served) {
		this.showCursor();
		log.leave("served by the module");
		return 0;
	}
	
	buflen=this.flush();
//	if (buflen)	
	switch (dir) {
			case -1:
				if (buflen) {
					if (this.pos>=buflen) this.pos-=buflen;
				} else if (this.pos>0) this.pos--;
				break;
			case 1:
				if (!buflen) if (this.pos<this.buf.length) this.pos++;
				break;
	}
	this.showCursor();
	this.log.log("doMove Leave");
}

TextInput.prototype.flush=function(){
	var c,s;
	var log=this.log.enter("flush");
	try {
		c=this.module.getBuf();
		log.log("insert",this.buf,this.pos,c);
		if (c.length>0) {
			this.buf=this.buf.insert(c,this.pos);
			this.pos+=c.length;
		}
		log.leave(c.length);
		return c.length;
	} catch(e) {log.error(e);}
}

TextInput.prototype.getValue=function(){
	var c,s;
	var log=this.log.enter("getValue");
	try {
		c=this.module.getBuf(true);
		log.log("insert",this.buf,this.pos,c);
		if (c.length>0) {
			s=this.buf.insert(c,this.pos);
		} else s=this.buf;
		log.leave(s);
		return s;
	} catch(e) {log.error(e);}
}
//zrobic to samo co z doMove
TextInput.prototype.extract=function(start,end){
	this.log.log("extract enter");
	var s,s2;
	s=this.buf.slice(start,finish);
	s2=this.buf.slice(0,start) + this.buf.slice(finish);
	this.buf=s2;
	this.pos=start;
	return s;
}
TextInput.prototype.doDelete=function(dir){
	var log=this.log.enter("doDelete",dir);
	try {
		this.keyPressNote();
		var s,served=false;
		if (this.module.doDelete) {
				served=this.module.doDelete(dir);	//powinno zwrocic nie-zero jesli obsluzyl poruszenie
		};
		if (served) {
			this.showCursor();
			log.leave("served by the module");
			return 0;
		}
		
		this.flush();
		switch (dir) {
			case -1:
				if (this.pos>0) {
					s=this.buf.slice(this.pos)
					this.pos--;
					this.buf=this.buf.slice(0,this.pos)+s;
				}
				break;
			case 1:
				if (this.pos<this.buf.length) {
					this.buf=this.buf.slice(0,this.pos)+this.buf.slice(this.pos+1);
				}
				break;
		}
		this.showCursor();
		log.leave("not served by the module");
	} catch (e) {log.error(e);}
}

TextInput.prototype.showCursor=function(buf) {
	var s,t;
	var log=this.log.enter("showCursor",this.buf,this.pos);
	try {
/*
		if (!buf) {
			s=this.buf.insert("_",this.pos);
		} else {
			s=this.buf.insert(buf,this.pos);
			s=s.insert("_",this.pos+buf.length);
		}
*/
		t=this.module.showCursor();
		s=this.buf.insert(t,this.pos);
		log.log(t,s);
		this.display(s)
		log.leave();
	} catch(e) { log.error(e);}
}

TextInput.prototype.doRight=function(){
}

//poprawic, zeby uwzglednial znaki przestankowe odpowiednie - trzeba funkcje napisac, ktora prawdopodobnie bedzie podpieta do noteKeyPress
TextInput.prototype.doSize=function(){
	var log=this.log.enter("doSize");
	log.log("doSize Enter");
//FIXME: metoda powinna myslec za siebie, czy jej sie podoba zmiana case'a
//	this.flush();
//should check for this.opts.cases, at least one should be available - if not, we assume we can't change them and leave;
	try {
		if (!(this.opts.cases & this.CALL)) return 0;
		if (!this.textCase) 
			this.textCase=1;
		else
			this.textCase<<=1;
		var mem=this.textCase;
		while (!(this.textCase & this.opts.cases) && this.textCase <= this.CMAX) this.textCase<<=1;
		
		if (this.textCase>this.CMAX){
			this.textCase=1;
			//here we assume, that there's at least one mode allowed
			while (!(this.textCase & this.opts.cases) && this.textCase <= this.CMAX) this.textCase<<=1;
		}
		MyDocument.AUTORUN_GROUP.textcase.setValue(this.CDESC[this.textCase]);
		log.leave();
	}catch(e) {log.error(e);}
//FIXME: trzeba jakos rozwiazac problem tekstowego opisu przypisanego do wartosci - moze tak jak z blinkiem, jak wprost nie zadziala	
/*	if (this.textCase==this.CUPPER) this.textCase=this.CLOWER; else this.textCase=this.CUPPER;
	switch(this.textCase) {
		case this.CLOWER:
//				MyDocument.STATUSLINE_GROUP.textModeIndicator.setValue("abc");
			this.UI.setVariable("TEXT_CASE","abc");
			break;
		case this.CUPPER:
//				MyDocument.STATUSLINE_GROUP.textModeIndicator.setValue("ABC");
			this.UI.setVariable("TEXT_CASE","ABC");
			break;
	}
*/
}

TextInput.prototype.next=function(){
	var log=this.log.enter("next");
	try {
		log.log(this.module.next);
		if (this.module.next) this.module.next();
		this.showCursor();
	} catch(e) { log.error(e);}
}

TextInput.prototype.prev=function(){
	var log=this.log.enter("prev");
	try {
		log.log(this.module.prev);
		if (this.module.prev) this.module.prev();
		this.showCursor();
	} catch(e) { log.error(e);}
	log.leave();
}

TextInput.prototype.setBuf=function(buf){
	//we can do verification here - masks, case, contents etc
	var log=this.log.enter("setBuf",buf);
	if (buf==null || buf==undefined) {
		log.log("ERROR: No buffer given");
		this.buf=""
		this.pos=0;
		this.module.getBuf();
		return "";
	}
	var s;
	try {
//		log.log(buf);
		log.log(this.module.setBuf);
		log.log(this.opts.mode);
		log.log(this.opts.multiword);
		if (this.opts.mode == this.MT9 && !this.opts.multiword) {
			this.buf="";
			if (this.module.setBuf) s=this.module.setBuf(buf);
			if (s.blink) {
				log.log(blink);
				this.UI.bubble("doBlink");
			}
			this.pos=0;
			log.leave("Set t9 buffer to "+s+";");
			return s;
		};
		this.pos=buf.length;
		this.buf=buf;
		this.module.getBuf(false);  //flush module's buffer
		log.leave("Set just internal buffer");
		return buf;
	} catch(e) { log.error(e);}
}


UIEdit=function(label,_opts){
	this.log=new Logger("UIEdit");
	this.log.log("Create");
	this.log.log(_opts)
	var opts;
	if (!_opts) opts={}; else opts=_opts;
	this.log.log(opts)
	label.log=this.log;
	this.log.log("textinput");
	this.log.log(TextInput);
	label.textInput=new TextInput(label,"_setValue",opts);
//	label.doDigit=label.textInput.doDigit;
	label.opts=opts
	this.log.log("1");
	label.doDigit=function(part){
//		this.setValue("Key Pressed " + part.key.charAt(0))
		this.textInput.doDigit(part);
	}
	this.log.log("2");
	label.doLeft=function(){
		this.textInput.doMove(-1);
	}
	this.log.log("3");
	label.doRight=function(){
		this.textInput.doMove(1);
	}
	this.log.log("4");
	label.doMenu=function(){
		var log=this.log.enter("doMenu");
		try {
			this.textInput.flush();
			log.log("revert to old buf",this.oldbuf);
			log.log(this.oldbuf,typeof(this.oldbuf),this.oldbuf.length);
			this.setValue(this.oldbuf);
			log.leave();
			this.container.focus(true);
		} catch(e) {log.error(e)}
//		this.container.enable(true);
	}

	this.log.log("5");
	label.doCenter=function(){
		var log=this.log.enter("doCenter");
		var s;
		try {
//			this.textInput.flush();
			s=this.textInput.getValue();
			log.log("got",s);
			this._setValue(s)
//			this.log.sync();
			log.log("onCommit?",this.onCommit);
			this._active=0;
			this.container.focus(true);
			if (!this.onCommit) {
				log.leave("no onCommit defined");
//				this.container.focus(true);
				return 0;
			};
			log.log(this.onCommit);
			log.log(this.onCommit.obj);
			log.log(this.onCommit.obj.name);
			log.log(this.onCommit.method);
			log.log(this.onCommit.obj[this.onCommit.method]);
//FIXME: zrobic to porzadnie
			if (this.onCommit.obj[this.onCommit.method]) {
				log.log("Running function");
				this.onCommit.obj[this.onCommit.method](s);
			} 
				else log.log("Not running function");
			log.leave("after onCommit");
		} catch(e) {
			this.log.error(e,"doCenter");
		}
		log.leave();
	}
	this.log.log("6");
	if (!label._focus) label._focus=label.focus;
//	label._focus=label.focus;
	this.log.log("7");
	label.focus=function(param){
		this._focus(param);
		if (this.onFocus) this.onFocus(param);
	}
	this.log.log("8");
	label.onFocus=function(param){
		var log = this.log.enter("onFocus",param);
		log.log(this.textInput.buf,this.textInput.getValue());
//		this.textInput.buf=this.getValue();
//		log.log(this.textInput.buf);
		this.oldbuf=this.getValue();
//		this.textInput.pos=this.textInput.buf.length;
//		this.textInput.doMove(1);
		this.textInput.showCursor()
//		log.log(this.textInput.buf);
		this._active=1;
		MyDocument.KEYBOARD_GROUP.show(true);
		log.leave();
	}
	this.log.log("9");
	label.doNext=function(param){
		var log=this.log.enter("doNext",param);
		this.textInput.doDelete(1);
		log.leave();
	}
	label.doUp=function(){
		this.textInput.prev();
	}
	label.doDown=function(){
		this.textInput.next();
	}
	this.log.log("0");
	label.doPrevious=function(param){
		var log=this.log.enter("doPrevious",param);
		this.textInput.doDelete(-1);
		log.leave();
	}
	this.log.log("1");
	label.doSize=function(){
		if (!this.textInput.opts.cases) {
			this.bubble("doBlink");
			return ;
		}
		this.textInput.doSize();
	}

	if (!label._setValue)label._setValue=label.setValue;
//	label._setValue=label.setValue;
	label.setValue=function(value){
		var s;
		s=this.textInput.setBuf(value);
		this._setValue(s);
	}
	label.doMark = function(){
		this.textInput.doMark();
	}
	label.doMarkMenu = function(){
		this.textInput.doMarkMenu();
	}
	this.log.log("End");
}

UIObject = function(cName){
	if (!cName) return;
	var f = function(UI) {
			if (!UI) return;
			var i;
			this.UI=UI;
			if (!this.log) this.log=new Logger(cName);
			this.log.log("construct",UI.construct,this.construct);
			for(i in this) {
				this.log.log("copy",i);
//FIXME: maybe it should store previous values/functions before changing
				UI[i]=this[i];
			}
			this.log.log("construct",UI.construct,this.construct);
			if (this.UI.construct) {
				this.log.log("args.len",arguments.length);
				if (arguments.length>1) {
					var args = new Array(arguments.length-1);
//					var len = arguments.length < this.con
//					args[0]=UI;
					for(i=1;i<arguments.length;i++) args[i-1]=arguments[i];
					this.log.log("args",args);
					this.construct.apply(this.UI,args);
				} else {
					this.UI.construct();
				}
			}
			this.log.log("OK");
			return UI;
		}
		f.inherits(UIObject);
	return f;
}
UIObject.prototype.construct=function() {
	if (this.log) this.log.log("UIObject constructor");
};

ScrollBar = new UIObject("ScrollBar");

ScrollBar.prototype.construct=function(x,y,w,h){
	try {
		this.uber('construct');
	} catch(e) { this.log.error(e,"inherited constructor");}
	var log=this.log.enter("construct",x,y,w,h);
	this.w=w;
	this.h=h;
	this.x=x;
	this.y=y;
	this.pad=1;
	this.bg.changeLayout(x,w,undefined,y,h,undefined);
	this.marker.changeLayout(x+this.pad,w-2*this.pad,undefined,y+this.pad,50,undefined);
	this.show(false);
	return this;
}

ScrollBar.prototype.set=function(pos,max,size){
	var y,h,part;
	var log=this.log.enter("set",pos,max,size);
	if (!size) var size=1;
	if (pos>max) var pos=max;
	try {
		part=(this.h-2*this.pad)/(max+1);
		h=part*size;
		log.log("part=",part);
		if (h<(this.w-2*this.pad)) h=this.w-2*this.pad
		log.log("h=",h);
		y=this.pad+pos*part;
		log.log(this.pad,pos,this.h,max);
		y=y|0;
		h=h|0;
		log.log("y=",y);
		this.marker.changeLayout(this.x+this.pad,this.w-2*this.pad,undefined,this.y+y,h,undefined);
		this.show(true);
		log.leave();
	} catch(e) {log.error(e);}
}
/*
target.trace(ScrollBar2);
target.trace("ScrollBar3");
//var sc = new ScrollBar2(MyDocument.DICTIONARY_GROUP.DICTIONARY.SCROLLBAR,0,0,14,696);
ScrollBar3 = new UIObject2("ScrollBar3");
target.trace("ScrollBar3");
ScrollBar3.inherits(ScrollBar2);

ScrollBar3.prototype.construct=function(x,y,w,h){
	try {
		this.uber('construct',x,y,w,h);
	} catch(e) { this.log.error(e,"inherited constructor");}
	var log=this.log.enter("construct3",x,y,w,h);
}
*/
//target.trace("ScrollBar3");

//var sc = new ScrollBar3(MyDocument.DICTIONARY_GROUP.DICTIONARY.SCROLLBAR,0,0,14,696);
/*

UIObject=function(UI){
//	Trace("UIObject constructor");	//skad on tam qwa bierze loggera z uiedit to ja nie wiem...
//	if (this.log) this.log.log("dupa");	//ten dziala tak jak ma dzialac
	if (!UI) return;
//	Trace(UI);
	return this.copy(UI);	//wywala sie...
}

UIObject.prototype.copy=function(UI) {
	for(var i in this) UI[i]=this[i];
	return UI;
}

ScrollBar=function(UI,x,y,w,h){
	this.log=new Logger("ScrollBar");
	this.log.log("constructor ok");
	this.UI=UI;
	this.w=w;
	this.h=h;
	this.x=x;
	this.y=y;
	this.pad=1;
	try {
		this.uber('constructor',UI);
	} catch(e) { this.log.error(e,"inherited constructor");}
	UI.bg.changeLayout(x,w,undefined,y,h,undefined);
	UI.marker.changeLayout(x+this.pad,w-2*this.pad,undefined,y+this.pad,50,undefined);
	UI.show(false);
	this.log.log(this.copy);
	return UI;
	return this.copy(UI);
}

//ScrollBar.inherits(UIObject);

ScrollBar.prototype.set=function(pos,max,size){
	var y,h,part;
	var log=this.log.enter("set",pos,max,size);
	if (!size) var size=1;
	if (pos>max) var pos=max;
	try {
		part=(this.h-2*this.pad)/(max+1);
		h=part*size;
		log.log("part=",part);
		if (h<(this.w-2*this.pad)) h=this.w-2*this.pad
		log.log("h=",h);
		y=this.pad+pos*part;
		log.log(this.pad,pos,this.h,max);
		y=y|0;
		h=h|0;
		log.log("y=",y);
		this.UI.marker.changeLayout(this.x+this.pad,this.w-2*this.pad,undefined,this.y+y,h,undefined);
		this.UI.show(true);
		log.leave();
	} catch(e) {log.error(e);}
}
*/

UITextView = new UIObject("UITextView");
//FIXME: should take at least w,h arguments
UITextView.prototype.construct=function(w,h) {
	this.uber('construct');
	var log = this.log.enter("construct","UITextView");
	log.log("const oK");
	this.lineLength=53;
	this.fromLine=0;
	this.w=w;
	this.h=h;
	var vpad=5;
	var i;
	try {
		for(i=0;i<100;i++) 
			if (!this["label"+i]) break;
		this.linesCount=i;
		log.log("linesCount",i);
		var h1=((this.h-2*vpad)/this.linesCount)|0;
		for(i=0;i<this.linesCount;i++){
			this["label"+i].changeLayout(22,undefined,5, vpad+h1*i,h1,undefined);
		}
		if (this.SCROLLBAR) this.scrollBar=new ScrollBar(this.SCROLLBAR,0,0,14,this.h-4);
		log.leave();
		return this;
	} catch(e) {this.log.error(e);}
}


UITextView.prototype.displayContents=function(fromLine) {
	var log=this.log.enter("displayContents",fromLine,this.contents.length);
	try {
		if (!fromLine) var fromLine=0;
		this.fromLine=fromLine;
		var lines=this.contents;
		log.log(fromLine,lines.length);
		for(i=0;(i+fromLine)<lines.length;i++) {
			if (!this["label"+i]) break;
//			log.log("display",i,i+fromLine,lines[i+fromLine]);
			this["label"+i].setValue(lines[i+fromLine]);
		}
		log.log("displayed lines from",fromLine+1,"to",fromLine+i,"out of",lines.length);
//		if (this.scrollBar) 
//			this.scrollBar.set(fromLine,lines.length-1,i);
		if (this.SCROLLBAR) 
			this.SCROLLBAR.set(fromLine,lines.length-1,i);
		for(;;i++) {
			if (!this["label"+i]) break;
//			log.log("clear",i);
			this["label"+i].setValue("");
		}
		log.leave("cleared");
	}catch(e) {log.error(e);}
}

UITextView.prototype.doUp=function(){
	var log=this.log.enter("doUp",this.fromLine);
	try {
		if (this.fromLine>0) 
			this.displayContents(this.fromLine-1);
		else
			this.bubble("doBlink");
	} catch(e) {log.error(e)};
}

UITextView.prototype.doDown=function(){
	var log=this.log.enter("doDown",this.fromLine,this.contents.length);
	try {
		if (this.fromLine<this.contents.length-1) 
			this.displayContents(this.fromLine+1);
		else
			this.bubble("doBlink");
	} catch(e) {log.error(e)};
}

UITextView.prototype.setValue=function(contents,fL) {
	var log=this.log.enter("setValue");
	log.flush();
	try {
		if (!fL) this.fromLine=0; else this.fromLine=fL;
		log.log("breakLines");
//to benchmark and optimize
//		log.log("======================================");//
//		var lines = this.breakLines(contents,this.lineLength);
//		log.log("======================================");//
//		var lines2 = this.breakLines2(contents,this.lineLength);
//		log.log("======================================"); //
		
		this.contents=this.breakLines2(contents,this.lineLength);
		log.log("display");
		this.displayContents(this.fromLine);
		log.leave();
	} catch(e) {log.error(e);}
}

UITextView.prototype.breakLines=function(s,w){
	var log=this.log.enter("breakLines",s.length,w);
	var i=0,i2,b1,b2,i3=0;
	var n=0;
	var debug=1;
	var lines=new Array()
	try {
		while (i<s.length) {
			if (i+w>=s.length && s.slice(i).indexOf("-|-")<0)
//		if (i+w>=s.length && s.slice(i).indexOf("\n")<0)
			{
				lines[n]=s.slice(i)
				break;
			}
			b2=s.slice(i,i+w)
			i2=b2.indexOf("-|-")
//		i2=b2.indexOf("\n")
			if (i2!=-1){
				if (i2>0) i3=1;
				if (b2.ltrim().indexOf("-|-")==0) {
//			if (b2.ltrim().indexOf("\n")==0) {
					i+=i2+4;
					continue;
				}
				lines[n]=s.slice(i,i+i2-i3)
				i+=i2+4;
				i3=0;
				n++;
				continue;
			}
			i2=b2.lastIndexOf(' ');
			if (debug) log.log(i2, (w*2/4),(i2>w*2/4),b2)
			if (i2>(w*2/4)){
				if (debug) log.log("Space break "+i+" "+i2+" "+n)
				lines[n]=s.slice(i,i+i2)
				i=i+i2+1;
			}else{
				if (debug) log.log("Force break "+i+" "+i2+" "+n)
				lines[n]=s.slice(i,i+w-1)+"-";
				i=i+w-1
			}
			n+=1;
		}
		log.leave();
		return lines;
	} catch(e) {log.error(e);}
}

UITextView.prototype.breakLines2=function(s,w){
	var log=this.log.enter("breakLines2",s.length,w);
	var res=[],i,arr2;
	var pos,lastindex,w2;
	var len;
	try {
		var arr1=s.split(" -|- ");
		log.log("initial count",arr1.length);
		for(i=0;i<arr1.length;i++) {
			len=arr1[i].length;
			if (len<=w) {
				log.log("pushing",arr1[i]);
				res.push(arr1[i]);
			} else {
				log.log("breaking",len,arr1[i]);
//				arr2=this.breakLines(arr1[i],w);
				pos=0;
				while (pos<len) {
					if (pos+w>len) {
						res.push(arr1[i].slice(pos));
						break;
					}
					lastindex=arr1[i].lastIndexOf(' ',pos+w);
					log.log("indexes:",pos,lastindex,pos+w);
					if (lastindex-pos>w/2) {
						res.push(arr1[i].slice(pos,lastindex));
						pos=lastindex+1;
					} else {
						res.push(arr1[i].slice(pos,w2-1)+"-");
						pos+=w2-1;			
					}
				}
//				log.log("broken",arr2.length);
//				res=res.concat(arr2);
			}
			log.log("i,length",i,res.length);
		}
		log.leave();
		return res;
	}catch(e){log.error(e);}
}


UIEdit2 = new UIObject("UIEdit2");

UIEdit2.prototype.construct=function(_opts){
	var log=this.log.enter("UIEdit2 construct");
	try {
		log.log("1");
		if (!this._focus) this._focus=this.focus;
		log.log("2");
		if (!this._setValue) this._setValue=this.setValue;
		log.log("3");
		this.uber("construct");
		log.log(_opts)
		var opts;
		if (!_opts) opts={}; else opts=_opts;
		log.log(opts)
//	label.log=log;
		log.log("textinput");
		log.log(TextInput);
		this.textInput=new TextInput(this,"_setValue",opts);
//	label.doDigit=label.textInput.doDigit;
		this.opts=opts
	} catch (e) {log.error(e)};
	log.leave();
}

UIEdit2.prototype.doDigit=function(part){
//		this.setValue("Key Pressed " + part.key.charAt(0))
	this.textInput.doDigit(part);
}
UIEdit2.prototype.doLeft=function(){
	this.textInput.doMove(-1);
}
UIEdit2.prototype.doRight=function(){
	this.textInput.doMove(1);
}
UIEdit2.prototype.doMenu=function(){
	var log=this.log.enter("doMenu");
	try {
		this.textInput.flush();
		log.log("revert to old buf",this.oldbuf);
		log.log(this.oldbuf,typeof(this.oldbuf),this.oldbuf.length);
		this.setValue(this.oldbuf);
		log.leave();
		this.container.focus(true);
	} catch(e) {log.error(e)}
//		this.container.enable(true);
}
UIEdit2.prototype.doCenter=function(){
	var log=this.log.enter("doCenter");
	var s;
	try {
//			this.textInput.flush();
		s=this.textInput.getValue();
		log.log("got",s);
		this._setValue(s)
//			this.log.sync();
		log.log("onCommit?",this.onCommit);
		this._active=0;
		if (!this.onCommit) {
			log.leave("no onCommit defined");
			this.container.focus(true);
			return 0;
		};
		log.log(this.onCommit);
		log.log(this.onCommit.obj);
		log.log(this.onCommit.obj.name);
		log.log(this.onCommit.method);
		log.log(this.onCommit.obj[this.onCommit.method]);
//FIXME: zrobic to porzadnie
		if (this.onCommit.obj[this.onCommit.method]) {
			log.log("Running function");
			this.onCommit.obj[this.onCommit.method](s);
		} 
			else log.log("Not running function");
		this.container.focus(true);
		log.leave("after onCommit");
	} catch(e) {
		this.log.error(e,"doCenter");
	}
	log.leave();
}
UIEdit2.prototype.focus=function(param){
	this._focus(param);
	if (this.onFocus) this.onFocus(param);
}
UIEdit2.prototype.onFocus=function(param){
	var log = this.log.enter("onFocus",param);
	log.log(this.textInput.buf,this.textInput.getValue());
//		this.textInput.buf=this.getValue();
//		log.log(this.textInput.buf);
	this.oldbuf=this.getValue();
//		this.textInput.pos=this.textInput.buf.length;
//		this.textInput.doMove(1);
	this.textInput.showCursor()
//		log.log(this.textInput.buf);
	this._active=1;
	log.leave();
}
UIEdit2.prototype.doNext=function(param){
	var log=this.log.enter("doNext",param);
	this.textInput.doDelete(1);
	log.leave();
}
UIEdit2.prototype.doUp=function(){
	this.textInput.prev();
}
UIEdit2.prototype.doDown=function(){
	this.textInput.next();
}
UIEdit2.prototype.doPrevious=function(param){
	var log=this.log.enter("doPrevious",param);
	this.textInput.doDelete(-1);
	log.leave();
}
UIEdit2.prototype.doSize=function(){
	if (!this.textInput.opts.cases) {
		this.bubble("doBlink");
		return ;
	}
	this.textInput.doSize();
}
UIEdit2.prototype.setValue=function(value){
	var s;
	s=this.textInput.setBuf(value);
	this._setValue(s);
}
UIEdit2.prototype.doMark = function(){
	this.textInput.doMark();
}
UIEdit2.prototype.doMarkMenu = function(){
	this.textInput.doMarkMenu();
}

